/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.pcal;

public interface IPCalReservedWords {
    public static final String ALGORITHM = "--algorithm";
    public static final String ASSERT = "assert";
    public static final String AWAIT = "await";
    public static final String BEGIN = "begin";
    public static final String CALL = "call";
    public static final String DEFINE = "define";
    public static final String DO = "do";
    public static final String EITHER = "either";
    public static final String ELSE = "else";
    public static final String ELSEIF = "elseif";
    public static final String END = "end";
    public static final String GOTO = "goto";
    public static final String IF = "if";
    public static final String MACRO = "macro";
    public static final String OR = "or";
    public static final String PRINT = "print";
    public static final String PROCEDURE = "procedure";
    public static final String PROCESS = "process";
    public static final String FAIR = "fair";
    public static final String RETURN = "return";
    public static final String SKIP = "skip";
    public static final String THEN = "then";
    public static final String VARIABLE = "variable";
    public static final String VARIABLES = "variables";
    public static final String WHILE = "while";
    public static final String WITH = "with";
    public static final String[] ALL_WORDS_ARRAY = new String[]{"assert", "begin", "call", "do", "either", "else", "elseif", "end", "goto", "if", "macro", "or", "print", "procedure", "process", "fair", "return", "skip", "then", "variable", "variables", "while", "with"};
    public static final String ALGORITHM_HELP = "<Algorithm> ::= [--algorithm | --fair algorithm] <name>\r\n\t\t{<VarDecls>{0,1}\r\n\t\t<Definitions>{0,1}\r\n\t\t<Macro>*\r\n\t\t<Procedure>*\r\n\t\t[<CompoundStmt> | [fair [+]{0,1}]{0,1}<Process>+] }\r\n\r\n<Definitions> ::= define { <Defs> } [;]{0,1}\r\n\r\n<Macro> ::= macro<Name> ( [ <Variable>[, <Variable>]* ]{0,1} )\r\n\t\t<CompoundStmt> [;]{0,1}\r\n\r\n<Procedure> ::= procedure<Name> ( [<PVarDecl> [,<PVarDecl>]*]{0,1} )\r\n\t\t<PVarDecls>{0,1}\r\n\t\t<CompoundStmt> [;]{0,1}\r\n\r\n<Process> ::= [fair [+]{0,1}]{0,1} process (<Name> [=|\\in] <Expr> )\r\n\t\t<VarDecls>{0,1}\r\n\t\t<CompoundStmt> [;]{0,1}\r\n\r\n<VarDecls> ::= [variable | variables] <VarDecl>+\r\n<VarDecl> ::=<Variable> [[=|\\in] <Expr>]{0,1} [;|,]\r\n\r\n<PVarDecls> ::= [variable | variables] [hPVarDecl> [;|,]]+\r\n<PVarDecl> ::=<Variable> [=<Expr>]{0,1}\r\n\r\n<CompoundStmt> ::= {<Stmt> [;<Stmt>]* [;]{0,1} }\r\n<Stmt> ::= [<Label> : [+|-]{0,1}]{0,1} [<UnlabeledStmt> |<CompoundStmt>]\r\n<UnlabeledStmt> ::=<Assign> |<If> |<While> |<Either> |<With> | <Await> |<Print> |<Assert> |<Skip> |<Return> | <Goto> |<Call> |<MacroCall>\r\n\r\n<Assign> ::=<LHS> := <Expr> [||<LHS> :=<Expr>]*\r\n<LHS> ::=<Variable> [[<Expr> [,<Expr>]*] | .<Field>]*\r\n\r\n<If> ::=>f (<Expr> )<Stmt> [else<Stmt>]{0,1}\r\n\r\n<While> ::= while (<Expr>)<Stmt>\r\n\r\n<Either> ::= either<Stmt> [or<Stmt>]+\r\n<With> ::= with (<Variable> [=|\\in] <Expr>\r\n\t\t\t[[; | ,]<Variable> [=|\\in] <Expr>]* [; | ,]{0,1}\r\n\t\t)<Stmt>\r\n\r\n<Await> ::= [await | when]<Expr>\r\n\r\n<Print> ::= print<Expr>\r\n\r\n<Assert> ::= assert<Expr>\r\n\r\n<Skip> ::= skip\r\n\r\n<Return> ::= return\r\n\r\n<Goto> ::= goto<Label>\r\n\r\n<Call> ::= call<MacroCall>\r\n\r\n<MacroCall> ::=<Name> ( [<Expr> [,<Expr>]*]{0,1} )\r\n\r\n<Variable> ::= A TLA+ identifier that is not a PlusCal reserved word and\r\nis not pc, stack, or self.\r\n\r\n<Field> ::= A TLA+ record-component label.\r\n\r\n<Name> ::= A TLA+ identifier that is not a PlusCal reserved word.\r\n\r\n<Label>  ::= A TLA+ identifier that is not a PlusCal reserved word and\r\nis not Done or Error.\r\n\r\n<Expr> ::= A TLA+ expression not containing a PlusCal reserved word\r\nor symbol.\r\n\r\n<Defs> ::= A sequence of TLA+ definitions not containing a PlusCal\r\nreserved word or symbol.";
    public static final String ASSIGN_HELP = "<Assign> ::= <LHS> := <Expr> [ || <LHS> := <Expr>]*\r\n\t<LHS> ::= <Variable> [[ <Expr> [, <Expr>]* ] | . <Field>]*\n\nAn assignment is either an assignment to a variable such as\r\n\ty := A + B\r\nor else an assignment to a component, such as\r\n\tx.foo[i+1] := y+3\r\nIf the current value of x is a record with a foo component that is a function\r\n(array), then this assignment sets the component x.foo[i+1] to the current\r\nvalue of y+3. The value of this assignment is undefined if the value of x is not\r\na record with a foo component, or if x.foo is not a function. Therefore, if\r\nsuch an assignment appears in the code, then x will usually be initialized to\r\nan element of the correct \u201ctype\u201d, or to be a member of some set of elements\r\nof the correct type. For example, the declaration\r\n\tvariable x \\in [bar : BOOLEAN,\r\n\t\tfoo : [1..N |-> {\"on\", \"off\"}] ] ;\r\nasserts that initially x is a record with a bar component that is a Boolean\r\n(equal to TRUE or FALSE) and a foo component that is a function with\r\ndomain 1.. N such that x.foo[i] equals either \u201con\u201d or \u201coff\u201d for each i in\r\n1.. N.\r\nAn assignment statement consists of one or more assignments, separated\r\nby \u201c||\u201d tokens, ending with a semicolon. An assignment statement contain-\r\ning more than one assignment is called a multiple assignment. A multiple\r\nassignment is executed by first evaluating the right-hand sides of all its as-\r\nsignments, and then performing those assignments from left to right. For\r\nexample, if i = j = 3, then executing\r\n\tx[i] := 1 || x[j] := 2\r\nsets x[3] to 2.\r\nAssignments to the same variable cannot be made in two different as-\r\nsignment statements within the same step. In other words, in any control\r\npath, a label must come between two statements that assign to the same\r\nvariable. However, assignments to components of the same variable may\r\nappear in a single multiple assignment, as in\r\n\tx.foo[7] := 13 || y := 27 || x.bar := x.foo";
    public static final String MULTI_ASSIGN_HELP = "A multiple\r\nassignment is executed by first evaluating the right-hand sides of all its as-\r\nsignments, and then performing those assignments from left to right. For\r\nexample, if i = j = 3, then executing\r\n\tx[i] := 1 || x[j] := 2\r\nsets x[3] to 2.\r\nAssignments to the same variable cannot be made in two different as-\r\nsignment statements within the same step. In other words, in any control\r\npath, a label must come between two statements that assign to the same\r\nvariable. However, assignments to components of the same variable may\r\nappear in a single multiple assignment, as in\r\n\tx.foo[7] := 13 || y := 27 || x.bar := x.foo";
    public static final String DEFINE_HELP = "<Definitions> ::= define { <Defs> }[;]{0,1}\n\nAn algorithm\u2019s expressions can use any operators defined in the TLA + mod-\r\nule before the \u201cBEGIN TRANSLATION\u201d line. Since the TLA + declaration of\r\nthe algorithm\u2019s variables follows that line, the definitions of those opera-\r\ntors can\u2019t mention any algorithm variables. The PlusCal define statement\r\nallows you to write TLA + definitions of operators that depend on the algo-\r\nrithm\u2019s global variables. For example, suppose the algorithm begins:\r\n\t--algorithm Test {\r\n\tvariables x \\in 1..N ; y ;\r\n\tdefine { zy == y*(x+y)\r\n\t\tzx(a) == x*(y-a) }\r\n\t...\r\nThe operators zy and zx can then be\r\nused in expressions anywhere in the remainder of the algorithm. Observe\r\nthat there is no semicolon or other separator between the two definitions.\r\nSection 5.11 on page 55 describes how to write TLA + definitions.\r\nThe variables that may appear within the define statement are the ones\r\ndeclared in the variable statement that immediately precedes it and that\r\nfollows the algorithm name, as well as the variable pc and, if there is a pro-\r\ncedure, the variable stack . Local process and procedure variables may not\r\nappear in the define statement. The define statement\u2019s definitions need\r\nnot mention the algorithm\u2019s variables. You might prefer to put definitions\r\nin the define statement even when they don\u2019t have to go there. However,\r\nremember that the define statement cannot mention any symbols defined\r\nor declared after the \u201cEND TRANSLATION\u201d line; and the symbols it defines\r\ncannot be used before the \u201cBEGIN TRANSLATION\u201d line.\r\nDefinitions, including ones in a define statement, are not expanded\r\nin the PlusCal to TLA + translation. All defined symbols appear in the\r\ntranslation exactly as they appear in the PlusCal code.";
    public static final String MACRO_HELP = "<Macro> ::= macro <Name> ( [<Variable>[, <Variable>]\u2217]{0,1})\n\t<CompoundStmt>[;]{0,1}\n\nA macro is like a procedure, except that a call of a macro is expanded at\r\ntranslation time. You can think of a macro as a procedure that is executed\r\nwithin the step from which it is called.\r\nA macro definition looks much like a procedure declaration - for example:\r\n\tmacro P(s, i) { await s \u2265 i ;\r\n\t\ts := s - i }\r\nThe difference is that the body of the macro may contain no labels, no\r\nwhile, call, return, or goto statement. It may contain a call of a previously\r\ndefined macro. Macro definitions come right after any global variable\r\ndeclarations and define section.\r\nA macro call is like a procedure call, except with the call omitted\u2014for\r\nexample:\r\n\tP(sem, y + 17) ;\r\nThe translation replaces the macro call with the sequence of statements ob-\r\ntained from the body of the macro definition by substituting the arguments\r\nof the call for the definition\u2019s parameters. Thus, this call of the P macro\r\nexpands to:\r\n\tawait sem \u2265 (y + 17) ;\r\n\tsem := sem - (y + 17) ;\nWhen translating a macro call, substitution is syntactic in the sense that\r\nthe meaning of any symbol in the macro definition other than a parameter\r\nis the meaning it has in the context of the call. For example, if the body of\r\nthe macro definition contains a symbol q and the macro is called within a\r\n\"with ( q \\in ... )\" statement, then the q in the macro expansion is the q\r\nintroduced by the with statement.\r\nWhen replacing a macro by its definition, the translation replaces every\r\ninstance of a macro parameter id in an expression within the macro body\r\nby the corresponding expression. Every instance includes any uses of id as\r\na bound variable, as in the expression\r\n\t[id \\id 1..N |-> false]\r\nThe substitution of an expression like y + 17 for id here will cause a mys-\r\nterious error when the translation is parsed. When using PlusCal, obey the\r\nTLA+ convention of never assigning a new meaning to any identifier that\r\nalready has a meaning.";
    public static final String GOTO_HELP = "<Goto> ::= goto <Label>\n\nExecuting the statement\r\n\tgoto lab ;\r\nends the execution of the current step and causes control to go to the state-\r\nment labeled lab. In any control path, a goto must be immediately followed\r\nby a label. (Remember that the control path by definition ignores the mean-\r\ning of the goto and continues to what is syntactically the next statement.)\r\nIt is legal for a goto to jump into the middle of a while or if statement,\r\nbut this sort of trickery should be avoided.";
    public static final String SKIP_HELP = "<Skip> ::= skip\n\nThe statement skip; does nothing.";
    public static final String ASSERT_HELP = "<Assert> ::= assert <Expr>\n\nThe statement\tassert expr;is equivalent to skip if expression expr equals true. If expr equals false,\r\nexecuting the statement causes TLC to produce an error message saying\r\nthat the assertion failed and giving the location of the assert statement.\r\nTLC may report a failed assertion even if the step containing the assert\r\nstatement is not executed because of an await statement that appears later\r\nin the step.\r\nAn algorithm containing an assert statement must be in a module that\r\nextends the TLC module.";
    public static final String PRINT_HELP = "<Print> ::= print <Expr>\n\nExecution of the statement\r\n\tprint expr;\r\nis equivalent to skip, except it causes TLC to print the current value of expr.\r\nTLC may print the value even if the step containing the print statement is\r\nnot executed because of an await statement that appears later in the step.\r\nAn algorithm containing a print statement must be in a module that\r\nextends the TLC module.";
    public static final String RETURN_HELP = "<Return> ::= return\n\nSee procedure!";
    public static final String AWAIT_HELP = "<Await> ::= [ await | when ] <Expr>\n\nA step containing the statement await expr can be executed only when the\r\nvalue of the Boolean expression expr is TRUE. Although it usually appears\r\nat the beginning of a step, an await statement can appear anywhere within\r\nthe step.\r\n\ta : x := y + 1 ;\r\n\tb: ...\r\nThe step from a to b can be executed only when the current value of y+1\r\nis positive. (Remember that an entire step must be executed; part of a step\r\ncannot be executed by itself.) The keyword when can be used instead of\r\nawait.";
    public static final String WITH_HELP = "<With> ::= with ( <Variable> [=|\\in] <Expr>\r\n\t[ [;|,] <Variable> [=|\\\\in] <Expr> ]* [;|,]{0,1}\r\n\t) <Stmt>\n\nThe statement\r\n\twith ( id \\in S ) body\r\nis executed by executing the (possibly compound) statement body with identifier\r\n id equal to a nondeterministically chosen element of S.\r\nExecution is impossible if S is empty.";
    public static final String EITHEROR_HELP = "<Either> ::= either <Stmt> [or <Stmt> ]+\n\nThe either statement has the form:\r\n\teither clause 1\r\n\tor clause 2\r\n\t.\r\n\t.\r\n\tor clause n\r\nwhere each clause i is a (possibly compound) statement. It is executed by\r\nnondeterministically choosing any clause i that is executable and executing\r\nit. The either statement can be executed iff at least one of those clauses can\r\nbe executed. If any clause i contains a call, return, or goto statement or a\r\nlabel, then the either statement must be followed by a labeled statement.\r\nThe statement\r\n\tif (test) t clause else e clause\r\nis equivalent to the following statement.\r\n\teither { await test ; t clause }\r\n\tor { await \u00actest ; e clause }";
    public static final String IFTHENELSE_HELP = "<If> ::= if ( <Expr> ) <Stmt> [else <Stmt>]{0,1}\n\nThe if statement has its usual meaning. The statement\r\n\tif ( test ) t clause else e clause\r\nis executed by evaluating the expression test and then executing the (pos-\r\nsibly compound) statement t clause or e clause depending on whether test\r\nequals true or false. The else clause is optional. An if statement must\r\nhave a non-empty then clause. An if statement that contains a call,\r\nreturn, or goto statement or a label within it must be followed by a\r\nlabeled statement. (A label on the if statement itself is not considered to be\r\nwithin the statement.)";
    public static final String VARIABLE_HELP = "<VarDecls> ::= [variable|variables] <VarDecl>+\r\n\t<VarDecl> ::= <Variable> [ [= |\\in] <Expr> ]{0,1} [;|,]\n\n";
    public static final String WHILE_HELP = "<While> ::= while ( <Expr> ) <Stmt>\n\nThe while statement has its usual meaning. The statement\r\n\tlb : while ( test ) body\r\nwhere body is a (possibly compound) statement, is executed like the following\r\nif statement.\r\n\tlb : if ( test ) { body ; goto lb }\r\nA while statement must be labeled. However, the statement following a\r\nwhile statement need not be labeled, even if there is a label in body.";
    public static final String PROCESS_HELP = "<Process> ::= [ fair [+]{0,1} ]{0,1} process ( <Name> [=|\\in] <Expr> )\r\n\t<VarDecls>{0,1}\r\n\t<CompoundStmt> [;]{0,1}\n\nA multiprocess algorithm contains one or more processes. A process begins\r\nin one of two ways:\r\n\tprocess ( ProcName \\in IdSet )\r\n\tprocess ( ProcName = Id )\r\nThe first form begins a process set, the second an individual process. The\r\nidentifier ProcName is the process or process set\u2019s name. The elements of\r\nthe set IdSet and the element Id are called process identifiers. The process\r\nidentifiers of different processes in the same algorithm must all be different.\r\nThis means that the semantics of TLA + must imply that they are different,\r\nwhich intuitively usually means that they must be of the same \u201ctype\u201d. (For\r\nexample, the semantics of TLA + does not specify whether or not a string\r\nmay equal a number.) For execution by TLC, this means that all process\r\nidentifiers must be comparable values, as defined in Specifying\r\nSystems.\r\nThe name ProcName has no significance; changing it does not change\r\nthe meaning of the process statement in any way. The name appears\r\nin the TLA + translation, and it should be different for different process\r\nstatements\r\nAs explained above in Section 2.6 on page 11, the process statement is\r\noptionally followed by declarations of local variables. The process body is a\r\nsequence of statements enclosed by braces ({ }). Its first statement must be\r\nlabeled. Within the body of a process set, self equals the current process\u2019s\r\nidentifier.\r\nA multiprocess algorithm is executed by repeatedly choosing an arbitrary\r\nprocess and executing one step of that process, if that step\u2019s execution is\r\npossible. Execution of the process\u2019s next step is impossible if the process has\r\nterminated, if its next step contains an await statement whose expression\r\nequals false, or if that step contains a statement of the form \u201cawait x \u2208 S \u201d\r\nand S equals the empty set. Fairness conditions may be specified on the choice\r\nof which processes\u2019 steps are to be executed.";
    public static final String CALL_HELP = "<Call> ::= call <MacroCall>\r\n\t<MacroCall> ::= <Name> ( [ <Expr>[, <Expr>]* ]{0,1} )\n\nSee procedure!";
    public static final String PROCEDURE_HELP = "<Procedure> ::= procedure <Name> ( [<PVarDecl> [, <PVarDecl>]* ]{0,1} )\r\n\t<PVarDecls>{0,1}\r\n\t<CompoundStmt> [;]{0,1}\n\nAn algorithm may have one or more procedures. If it does, the algorithm\r\nmust be in a TLA + module that extends the Sequences module.\r\nThe algorithm\u2019s procedures follow its global variable declarations and\r\ndefine section (if any) and precede the \u201c{\u201d that begins the body of a\r\nuniprocess algorithm or the first process of a multiprocess algorithm. A\r\nprocedure named PName begins\r\n\tprocedure PName ( param 1 , . . . , param n )\r\nwhere the identifiers param i are the formal parameters of the procedure.\r\nThese parameters are treated as variables and may be assigned to. As ex-\r\nplained in Section 4.5 on page 37, there may also be initial-value assignments\r\nof the parameters.\r\nThe procedure statement is optionally followed by declarations of vari-\r\nables local to the procedure. These have the same form as the declara-\r\ntions of global variables, except that initializations may only have the form\r\n\u201cvariable = expression\u201d. The procedure\u2019s local variables are initialized on\r\neach entry to the procedure.\r\nAny variable declarations are followed by the procedure\u2019s body, which\r\nis a sequence of statements enclosed by braces ({ }). The body must begin\r\nwith a labeled statement. There is an implicit label Error immediately\r\nafter the body. If control ever reaches that point, then execution of either\r\nthe process (multiprocess algorithm) or the complete algorithm (uniprocess\r\nalgorithm) halts.\r\nA procedure PName can be called by the statement\r\n\tcall PName ( expr 1 , . . . , expr n )\r\nExecuting this call assigns the current values of the expressions expr i to the\r\ncorresponding parameters param i , initializes the procedure\u2019s local variables,\r\nand puts control at the beginning of the procedure body.\r\nA return statement assigns to the parameters and local procedure vari-\r\nables their previous values\u2014that is, the values they had before the procedure\r\nwas last called\u2014and returns control to the point immediately following the\r\ncall statement.\r\nThe call and return statements are considered to be assignments to the\r\nprocedure\u2019s parameters and local variables. In particular, they are included\r\nin the rule that a variable can be assigned a value by at most one assignment\r\nstatement in a step. For example, if x is a local variable of procedure P ,\r\nthen a step within the body of P that (recursively) calls P cannot also assign\r\na value to x.\r\nFor a multiprocess algorithm, the identifier self in the body of a proce-\r\ndure equals the process identifier of the process within which the procedure\r\nis executing.\r\nThe return statement has no argument. A PlusCal procedure does not\r\nexplicitly return a value. A value can be returned by having the procedure\r\nset a global variable and having the code immediately following the call\r\nread that variable. For example, in a multiprocess algorithm, procedure P\r\nmight use a global variable rVal to return a value by executing\r\n\trVal[self] := ... ;\r\n\treturn ;\r\nFrom within a process in a process set, the code that calls P might look like\r\nthis:\r\ncall P(17) ;\r\nlab: x := ... rVal[self] ... ;\r\nFor a call from within a single process, the code would contain the process\u2019s\r\nidentifier instead of self.\r\nIn any control path, a return statement must be immediately followed\r\nby a label. A call statement must either be followed in the control path by\r\na label or else it must appear immediately before a return statement in a\r\nstatement sequence.\r\nWhen a call P statement is followed immediately by a return, the\r\nreturn from procedure P and the return performed by the return statement\r\nare both executed as part of a single execution step. When these statements\r\nare in the (recursive) procedure P , this combining of the two returns is\r\nessentially the standard optimization of replacing tail recursion by a loop.";
}

