/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.util.HashSet;
import java.util.Set;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import util.Assert;

public final class SetOfStates {
    private TLCState[] states;
    private int count = 0;
    private int length;
    private int thresh;
    private int iteratorIndex = 0;

    public SetOfStates() {
        this(16);
    }

    public SetOfStates(int size) {
        this.length = size;
        this.thresh = this.length / 2;
        this.states = new TLCState[this.length];
    }

    public SetOfStates(StateVec sv, ITool tool) {
        this(sv.size());
        int i = 0;
        while (i < sv.size()) {
            this.put(sv.elementAt(i), tool);
            ++i;
        }
    }

    public SetOfStates(StateVec sv) {
        this(sv.size());
        int i = 0;
        while (i < sv.size()) {
            this.put(sv.elementAt(i));
            ++i;
        }
    }

    public final void clear() {
        this.count = 0;
        this.states = new TLCState[this.length];
    }

    private final void grow(ITool tool) {
        TLCState[] old = this.states;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.states = new TLCState[this.length];
        int i = 0;
        while (i < old.length) {
            TLCState s = old[i];
            if (s != null) {
                this.put(s.fingerPrint(tool), s, tool);
            }
            ++i;
        }
    }

    private final void grow() {
        TLCState[] old = this.states;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.states = new TLCState[this.length];
        int i = 0;
        while (i < old.length) {
            TLCState s = old[i];
            if (s != null) {
                this.put(s.fingerPrint(), s);
            }
            ++i;
        }
    }

    public final boolean put(TLCState aState, ITool tool) {
        return this.put(aState.fingerPrint(tool), aState, tool);
    }

    public final boolean put(TLCState aState) {
        return this.put(aState.fingerPrint(), aState);
    }

    public final boolean put(long fingerprint, TLCState aState, ITool tool) {
        if (this.count >= this.thresh) {
            this.grow(tool);
        }
        return this.put0(fingerprint, aState);
    }

    public final boolean put(long fingerprint, TLCState aState) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        return this.put0(fingerprint, aState);
    }

    private boolean put0(long fingerprint, TLCState aState) {
        int loc = ((int)fingerprint & Integer.MAX_VALUE) % this.length;
        while (true) {
            block5: {
                TLCState ent;
                if ((ent = this.states[loc]) == null) {
                    this.states[loc] = aState;
                    ++this.count;
                    return false;
                }
                try {
                    if (aState.equals(ent)) {
                        return true;
                    }
                }
                catch (Assert.TLCRuntimeException e) {
                    if ($assertionsDisabled || e.getMessage() != null && (e.getMessage().startsWith("Attempted to check equality of") || e.getMessage().startsWith("Attempted to compare equality of"))) break block5;
                    throw new AssertionError();
                }
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int capacity() {
        return this.length;
    }

    public final int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        int i = 0;
        while (i < this.states.length) {
            TLCState tlcState = this.states[i];
            if (tlcState != null) {
                buf.append("<<");
                buf.append(tlcState.fingerPrint());
                buf.append(",");
                String toStr = tlcState.toString();
                buf.append(toStr.substring(0, toStr.length() - 1));
                buf.append(">>,\n");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public Set<TLCState> getSubSet(Action a) {
        HashSet<TLCState> subset = new HashSet<TLCState>(this.size());
        int i = 0;
        while (i < this.size()) {
            TLCState next = this.next();
            if (a == next.getAction()) {
                subset.add(next);
            }
            ++i;
        }
        this.resetNext();
        return subset;
    }

    public final TLCState next() {
        TLCState next = null;
        while ((next = this.states[this.iteratorIndex++]) == null) {
        }
        return next;
    }

    public void resetNext() {
        this.iteratorIndex = 0;
    }
}

