/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.st.TreeNode;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNState;
import tlc2.util.Context;
import tlc2.value.IBoolValue;
import tlc2.value.IValue;
import util.Assert;

class LNStateAST
extends LNState {
    private final ExprNode body;

    public LNStateAST(ExprNode body, Context con) {
        super(con);
        this.body = body;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        IValue val = tool.eval(this.body, this.getContext(), s1);
        if (!(val instanceof IBoolValue)) {
            Assert.fail(2250);
        }
        return ((IBoolValue)val).getVal();
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        sb.append(this.body);
    }

    @Override
    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        if (this.body instanceof OpApplNode) {
            TreeNode[] zero;
            OpApplNode oan = (OpApplNode)this.body;
            sb.append("(");
            TreeNode[] treeNodeArray = zero = oan.getTreeNode().zero();
            int n = zero.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode treeNode = treeNodeArray[n2];
                SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
                sb.append(stn.getHumanReadableImage());
                ++n2;
            }
            TreeNode[] one = oan.getTreeNode().one();
            if (one != null) {
                TreeNode[] treeNodeArray2 = one;
                int n3 = one.length;
                n = 0;
                while (n < n3) {
                    TreeNode treeNode = treeNodeArray2[n];
                    SyntaxTreeNode stn = (SyntaxTreeNode)treeNode;
                    sb.append(stn.getHumanReadableImage());
                    ++n;
                }
            }
            sb.append(")");
        } else {
            this.toString(sb, "");
        }
        return sb.toString();
    }
}

