/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.EvalException;
import tlc2.tool.liveness.BEGraphNode;
import tlc2.tool.liveness.NodeTable;
import tlc2.util.MemObjectQueue;
import tlc2.util.MemObjectStack;
import tlc2.util.Vect;

public class BEGraph {
    public Vect<BEGraphNode> initNodes = new Vect();
    public String metadir;
    public NodeTable allNodes;

    public BEGraph(String metadir, boolean isBT) {
        this.metadir = metadir;
        this.allNodes = new NodeTable(127, isBT);
    }

    public final void resetNumberField() {
        MemObjectStack stack = new MemObjectStack(this.metadir, "resetstack");
        int i = 0;
        while (i < this.initNodes.size()) {
            BEGraphNode node = this.initNodes.elementAt(i);
            if (node.resetNumberField() != 0L) {
                stack.push(this.initNodes.elementAt(i));
            }
            ++i;
        }
        while (stack.size() != 0) {
            BEGraphNode node = (BEGraphNode)stack.pop();
            int i2 = 0;
            while (i2 < node.nextSize()) {
                BEGraphNode node1 = node.nextAt(i2);
                if (node1.resetNumberField() != 0L) {
                    stack.push(node1);
                }
                ++i2;
            }
        }
    }

    public final BEGraphNode getInitNode(int i) {
        return this.initNodes.elementAt(i);
    }

    public final void addInitNode(BEGraphNode node) {
        this.initNodes.addElement(node);
    }

    public final int initSize() {
        return this.initNodes.size();
    }

    public static BEGraphNode[] getPath(BEGraphNode start, BEGraphNode end) {
        if (start.equals(end)) {
            start.setParent(null);
        } else {
            boolean unseen = start.getVisited();
            MemObjectQueue queue = new MemObjectQueue(null);
            start.flipVisited();
            queue.enqueue(new NodeAndParent(start, null));
            boolean found = false;
            while (!found) {
                NodeAndParent np = (NodeAndParent)queue.dequeue();
                if (np == null) {
                    throw new EvalException(2159);
                }
                BEGraphNode curNode = np.node;
                int i = 0;
                while (i < curNode.nextSize()) {
                    BEGraphNode nextNode = curNode.nextAt(i);
                    if (nextNode.getVisited() == unseen) {
                        if (nextNode.equals(end)) {
                            end.setParent(curNode);
                            found = true;
                            break;
                        }
                        nextNode.flipVisited();
                        queue.enqueue(new NodeAndParent(nextNode, curNode));
                    }
                    ++i;
                }
                curNode.setParent(np.parent);
            }
        }
        Vect<BEGraphNode> path = new Vect<BEGraphNode>();
        BEGraphNode curNode = end;
        while (curNode != null) {
            path.addElement(curNode);
            curNode = curNode.getParent();
        }
        int sz = path.size();
        BEGraphNode[] bpath = new BEGraphNode[sz];
        int i = 0;
        while (i < sz) {
            bpath[i] = (BEGraphNode)path.elementAt(sz - i - 1);
            ++i;
        }
        return bpath;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        int sz = this.initNodes.size();
        if (sz != 0) {
            boolean seen = this.getInitNode(0).getVisited();
            int i = 0;
            while (i < this.initNodes.size()) {
                BEGraphNode node = this.getInitNode(i);
                node.toString(buf, seen);
                ++i;
            }
        }
        return buf.toString();
    }

    private static class NodeAndParent {
        BEGraphNode node;
        BEGraphNode parent;

        NodeAndParent(BEGraphNode node, BEGraphNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

