/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.util.BitVector;

public abstract class AbstractGraphNode {
    protected BitVector checks;

    public AbstractGraphNode(BitVector bitVector) {
        this.checks = bitVector;
    }

    public boolean getCheckState(int i) {
        return this.checks.get(i);
    }

    public BitVector getCheckAction(int slen, int alen, int nodeIdx) {
        BitVector bv = new BitVector(alen);
        int j = 0;
        while (j < alen) {
            bv.set(j, this.getCheckAction(slen, alen, nodeIdx, j));
            ++j;
        }
        return bv;
    }

    public boolean getCheckAction(int slen, int alen, int nodeIdx, int i) {
        int pos = slen + alen * nodeIdx + i;
        return this.checks.get(pos);
    }

    public boolean getCheckAction(int slen, int alen, int nodeIdx, int[] is) {
        int len = is.length;
        int i = 0;
        while (i < len) {
            int pos = slen + alen * nodeIdx + is[i];
            if (!this.checks.get(pos)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setCheckState(boolean[] vals) {
        int len = vals.length;
        int i = 0;
        while (i < len) {
            if (vals[i]) {
                this.checks.set(i);
            }
            ++i;
        }
    }
}

