/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import util.ResourceLocator;

class SequentialResourceLocator
implements ResourceLocator {
    private final List<ResourceLocator> locators;

    public SequentialResourceLocator(List<ResourceLocator> locators) {
        this.locators = locators;
    }

    @Override
    public URL locate(String filename) throws IOException {
        for (ResourceLocator locator : this.locators) {
            URL found = locator.locate(filename);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public String describeSearchLocations() {
        return this.locators.stream().map(ResourceLocator::describeSearchLocations).collect(Collectors.joining(", "));
    }
}

