/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tla2sany.semantic.ExprNode;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.util.Context;
import tlc2.value.IBoolValue;
import tlc2.value.IValue;
import util.Assert;
import util.WrongInvocationException;

public class LNAction
extends LiveExprNode {
    private final ExprNode body;
    private final ExprNode subscript;
    private final boolean isBox;
    private final Context con;
    private int tag;

    public LNAction(ExprNode body, Context con, ExprNode subscript, boolean isBox) {
        this.body = body;
        this.subscript = subscript;
        this.isBox = isBox;
        this.con = con;
    }

    public LNAction(ExprNode body, Context con) {
        this.body = body;
        this.subscript = null;
        this.isBox = false;
        this.con = con;
    }

    public final int getTag() {
        return this.tag;
    }

    public final void setTag(int t) {
        this.tag = t;
    }

    @Override
    public final int getLevel() {
        return 2;
    }

    @Override
    public final boolean containAction() {
        return true;
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        IValue val;
        if (this.subscript != null) {
            IValue v1 = tool.eval(this.subscript, this.con, s1, TLCState.Empty, 0);
            IValue v2 = tool.eval(this.subscript, this.con, s2, null, 0);
            boolean isStut = v1.equals(v2);
            if (this.isBox) {
                if (isStut) {
                    return true;
                }
            } else if (isStut) {
                return false;
            }
        }
        if (!((val = tool.eval(this.body, this.con, s1, s2, 0)) instanceof IBoolValue)) {
            Assert.fail(2252);
        }
        return ((IBoolValue)val).getVal();
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        if (this.subscript == null) {
            this.body.toString(sb, padding);
        } else {
            sb.append(this.isBox ? "[" : "<");
            this.body.toString(sb, padding + " ");
            sb.append((this.isBox ? "]_" : ">_") + String.valueOf(this.subscript));
        }
    }

    @Override
    public int tagExpr(int tag) {
        this.setTag(tag);
        return tag + 1;
    }

    @Override
    public LiveExprNode makeBinary() {
        throw new WrongInvocationException("LiveExprNode.makeBinary: TLC encounters actions.");
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNAction) {
            return this.getTag() == ((LNAction)exp).getTag();
        }
        return false;
    }
}

