/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import pcal.MappingObject;
import pcal.PCalLocation;
import pcal.Region;

public class TLAtoPCalMapping
implements Serializable {
    private static final long serialVersionUID = 4996600307008990835L;
    private MappingObject[][] mapping = new MappingObject[0][];
    public int tlaStartLine;
    public int algLine;
    public int algColumn;

    public void makeMapping(Vector<Vector<MappingObject>> mapVec) {
        this.mapping = new MappingObject[mapVec.size()][];
        int i = 0;
        while (i < this.mapping.length) {
            Vector<MappingObject> line = mapVec.elementAt(i);
            this.mapping[i] = new MappingObject[line.size()];
            int j = 0;
            while (j < line.size()) {
                this.mapping[i][j] = line.elementAt(j);
                ++j;
            }
            ++i;
        }
    }

    public Region mapTLAtoPCalRegion(Region tlaRegion, int currentAlgorithmLine) {
        int delta = currentAlgorithmLine - this.algLine;
        tlaRegion.getBegin().adjustLineBy(this.tlaStartLine + delta);
        tlaRegion.getEnd().adjustLineBy(this.tlaStartLine + delta);
        Region pcalRegion = TLAtoPCalMapping.ApplyMapping(this, tlaRegion);
        if (pcalRegion != null) {
            pcalRegion.getBegin().adjustLineBy(delta);
            pcalRegion.getEnd().adjustLineBy(delta);
        }
        return pcalRegion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.algColumn;
        result = 31 * result + this.algLine;
        result = 31 * result + Arrays.hashCode((Object[])this.mapping);
        result = 31 * result + this.tlaStartLine;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TLAtoPCalMapping other = (TLAtoPCalMapping)obj;
        if (this.algColumn != other.algColumn) {
            return false;
        }
        if (this.algLine != other.algLine) {
            return false;
        }
        if (this.tlaStartLine != other.tlaStartLine) {
            return false;
        }
        return this.equals(this.mapping, other.mapping);
    }

    private boolean equals(MappingObject[][] m, MappingObject[][] m2) {
        if (m == m2) {
            return true;
        }
        if (m == null || m2 == null) {
            return false;
        }
        int length = m.length;
        if (m2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            Object[] o1 = m[i];
            Object[] o2 = m2[i];
            if (o1 == null ? o2 != null : !Arrays.equals(o1, o2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int GetLineOfPCalAlgorithm(String moduleAsString) {
        int algorithmStringLocation = moduleAsString.indexOf("--algorithm");
        int fairStringLocation = moduleAsString.indexOf("--fair");
        if (fairStringLocation == -1 || algorithmStringLocation != -1 && algorithmStringLocation < fairStringLocation) {
            return algorithmStringLocation;
        }
        int i = fairStringLocation + "--fair".length();
        while (Character.isWhitespace(moduleAsString.charAt(i))) {
            ++i;
        }
        if (i != fairStringLocation + "--fair".length() && moduleAsString.startsWith("algorithm", i) && !Character.isLetterOrDigit(moduleAsString.charAt(i + "algorithm".length()))) {
            return fairStringLocation;
        }
        return algorithmStringLocation;
    }

    public static Region ApplyMapping(TLAtoPCalMapping mapping, Region tpregion) {
        boolean sourceTok;
        MappingObject[][] tpMap = mapping.mapping;
        Region tokPairRegion = TLAtoPCalMapping.RegionToTokPair(tpMap, tpregion);
        if (tokPairRegion == null) {
            return null;
        }
        PCalLocation ltok = tokPairRegion.getBegin();
        PCalLocation rtok = tokPairRegion.getEnd();
        int rtokDepth = 0;
        int minDepth = 0;
        boolean allExpr = false;
        MappingObject ltokObj = TLAtoPCalMapping.ObjectAt(ltok, tpMap);
        MappingObject rtokObj = TLAtoPCalMapping.ObjectAt(rtok, tpMap);
        if (ltokObj.getType() == 4) {
            allExpr = true;
            minDepth = -1;
            rtokDepth = -1;
        }
        PCalLocation i = TLAtoPCalMapping.NextLocOf(ltok, tpMap);
        while (TLAtoPCalMapping.LTEq(i, rtok)) {
            int newDepth = TLAtoPCalMapping.ModifiedDepth(rtokDepth, i, true, tpMap);
            if (newDepth < minDepth) {
                minDepth = newDepth;
                allExpr = true;
            } else if (newDepth == rtokDepth && newDepth == minDepth) {
                allExpr = allExpr && TLAtoPCalMapping.ObjectAt(i, tpMap).getType() == 4;
            }
            rtokDepth = newDepth;
            i = TLAtoPCalMapping.NextLocOf(i, tpMap);
        }
        if (rtokObj.getType() == 4 && ++rtokDepth < minDepth) {
            minDepth = rtokDepth;
        }
        if (allExpr) {
            ++minDepth;
        }
        int curDepth = 0;
        i = ltok;
        boolean bl = sourceTok = ltokObj.getType() == 4;
        if (minDepth != 0 || !sourceTok) {
            if (sourceTok) {
                curDepth = -1;
            }
            i = TLAtoPCalMapping.PrevLocOf(ltok, tpMap);
            while (TLAtoPCalMapping.ObjectAt(i, tpMap).getType() != 0 || curDepth != minDepth) {
                curDepth = TLAtoPCalMapping.ModifiedDepth(curDepth, i, false, tpMap);
                i = TLAtoPCalMapping.PrevLocOf(i, tpMap);
            }
        }
        MappingObject bParen = TLAtoPCalMapping.ObjectAt(i, tpMap);
        curDepth = rtokDepth;
        i = rtok;
        boolean bl2 = sourceTok = rtokObj.getType() == 4;
        if (minDepth != rtokDepth || !sourceTok) {
            if (sourceTok) {
                --curDepth;
            }
            i = TLAtoPCalMapping.NextLocOf(rtok, tpMap);
            while (TLAtoPCalMapping.ObjectAt(i, tpMap).getType() != 1 || curDepth != minDepth) {
                curDepth = TLAtoPCalMapping.ModifiedDepth(curDepth, i, true, tpMap);
                i = TLAtoPCalMapping.NextLocOf(i, tpMap);
            }
        }
        MappingObject eParen = TLAtoPCalMapping.ObjectAt(i, tpMap);
        PCalLocation lpos = bParen.getType() == 4 ? ((MappingObject.SourceToken)bParen).getOrigin().getBegin() : ((MappingObject.LeftParen)bParen).getLocation();
        PCalLocation rpos = eParen.getType() == 4 ? ((MappingObject.SourceToken)eParen).getOrigin().getEnd() : ((MappingObject.RightParen)eParen).getLocation();
        if (lpos.getLine() == 0 && lpos.getColumn() == 0) {
            return null;
        }
        return new Region(lpos, rpos);
    }

    private static int ModifiedDepth(int var, PCalLocation pos, boolean movingForward, MappingObject[][] tpMap) {
        int amt = 0;
        int type = TLAtoPCalMapping.ObjectAt(pos, tpMap).getType();
        if (type == 0) {
            amt = 1;
        } else if (type == 1) {
            amt = -1;
        }
        return var + (movingForward ? amt : -amt);
    }

    private static Region RegionToTokPair(MappingObject[][] spec, Region reg) {
        PCalLocation regBegin = reg.getBegin();
        PCalLocation regEnd = reg.getEnd();
        if (regEnd.getLine() < 0 || regBegin.getLine() >= spec.length) {
            return null;
        }
        if (regBegin.getLine() < 0) {
            regBegin = new PCalLocation(0, 0);
        }
        if (regEnd.getLine() >= spec.length) {
            regEnd = new PCalLocation(spec.length - 1, 999);
        }
        PCalLocation tokAtOrRightOfBeginning = null;
        boolean prevIsBeginToLeft = false;
        boolean notDone = true;
        int locLine = regBegin.getLine();
        while (locLine < spec.length && spec[locLine].length == 0) {
            ++locLine;
        }
        if (locLine >= spec.length) {
            notDone = false;
        }
        PCalLocation loc = new PCalLocation(locLine, 0);
        PCalLocation prevloc = null;
        while (notDone && loc != null) {
            if (prevIsBeginToLeft) {
                MappingObject.EndTLAToken mobj = (MappingObject.EndTLAToken)TLAtoPCalMapping.ObjectAt(loc, spec);
                if (TLAtoPCalMapping.LT(regBegin, new PCalLocation(loc.getLine(), mobj.getColumn()))) {
                    tokAtOrRightOfBeginning = prevloc;
                    notDone = false;
                } else {
                    prevIsBeginToLeft = false;
                }
            } else {
                MappingObject obj = TLAtoPCalMapping.ObjectAt(loc, spec);
                if (obj.getType() == 3) {
                    MappingObject.EndTLAToken eobj = (MappingObject.EndTLAToken)obj;
                    if (TLAtoPCalMapping.LT(regBegin, new PCalLocation(loc.getLine(), eobj.getColumn()))) {
                        tokAtOrRightOfBeginning = TLAtoPCalMapping.PrevLocOf(loc, spec);
                        notDone = false;
                    }
                } else if (obj.getType() == 2) {
                    MappingObject.BeginTLAToken bobj = (MappingObject.BeginTLAToken)obj;
                    if (TLAtoPCalMapping.LTEq(regBegin, new PCalLocation(loc.getLine(), bobj.getColumn()))) {
                        tokAtOrRightOfBeginning = loc;
                        notDone = false;
                    } else {
                        prevIsBeginToLeft = true;
                    }
                } else if (obj.getType() == 4) {
                    MappingObject.SourceToken sobj = (MappingObject.SourceToken)obj;
                    if (TLAtoPCalMapping.LT(regBegin, new PCalLocation(loc.getLine(), sobj.getEndColumn()))) {
                        tokAtOrRightOfBeginning = loc;
                        notDone = false;
                    }
                }
            }
            prevloc = loc;
            loc = TLAtoPCalMapping.NextLocOf(loc, spec);
        }
        PCalLocation tokAtOrLeftOfEnd = null;
        boolean prevIsEndToRight = false;
        notDone = true;
        locLine = regEnd.getLine();
        while (locLine >= 0 && spec[locLine].length == 0) {
            --locLine;
        }
        if (locLine < 0) {
            notDone = false;
        }
        loc = new PCalLocation(locLine, spec[locLine].length - 1);
        prevloc = null;
        while (notDone && loc != null) {
            if (prevIsEndToRight) {
                MappingObject.BeginTLAToken mobj = (MappingObject.BeginTLAToken)TLAtoPCalMapping.ObjectAt(loc, spec);
                if (TLAtoPCalMapping.LT(new PCalLocation(loc.getLine(), mobj.getColumn()), regEnd)) {
                    tokAtOrLeftOfEnd = prevloc;
                    notDone = false;
                } else {
                    prevIsEndToRight = false;
                }
            } else {
                MappingObject obj = TLAtoPCalMapping.ObjectAt(loc, spec);
                if (obj.getType() == 2) {
                    MappingObject.BeginTLAToken eobj = (MappingObject.BeginTLAToken)obj;
                    if (TLAtoPCalMapping.LT(new PCalLocation(loc.getLine(), eobj.getColumn()), regEnd)) {
                        tokAtOrLeftOfEnd = TLAtoPCalMapping.NextLocOf(loc, spec);
                        notDone = false;
                    }
                } else if (obj.getType() == 3) {
                    MappingObject.EndTLAToken bobj = (MappingObject.EndTLAToken)obj;
                    if (TLAtoPCalMapping.LTEq(new PCalLocation(loc.getLine(), bobj.getColumn()), regEnd)) {
                        tokAtOrLeftOfEnd = loc;
                        notDone = false;
                    } else {
                        prevIsEndToRight = true;
                    }
                } else if (obj.getType() == 4) {
                    MappingObject.SourceToken sobj = (MappingObject.SourceToken)obj;
                    if (TLAtoPCalMapping.LT(new PCalLocation(loc.getLine(), sobj.getBeginColumn()), regEnd)) {
                        tokAtOrLeftOfEnd = loc;
                        notDone = false;
                    }
                }
            }
            prevloc = loc;
            loc = TLAtoPCalMapping.PrevLocOf(loc, spec);
        }
        if (tokAtOrRightOfBeginning != null) {
            int type;
            if (tokAtOrLeftOfEnd == null) {
                return new Region(tokAtOrRightOfBeginning, tokAtOrRightOfBeginning);
            }
            if (TLAtoPCalMapping.LTEq(tokAtOrRightOfBeginning, tokAtOrLeftOfEnd)) {
                return new Region(tokAtOrRightOfBeginning, tokAtOrLeftOfEnd);
            }
            MappingObject obj = TLAtoPCalMapping.ObjectAt(tokAtOrLeftOfEnd, spec);
            int distToLeft = obj.getType() == 3 ? TLAtoPCalMapping.Dist(new PCalLocation(tokAtOrLeftOfEnd.getLine(), ((MappingObject.EndTLAToken)obj).getColumn()), regBegin) : TLAtoPCalMapping.Dist(new PCalLocation(tokAtOrLeftOfEnd.getLine(), ((MappingObject.SourceToken)obj).getEndColumn()), regEnd);
            obj = TLAtoPCalMapping.ObjectAt(tokAtOrRightOfBeginning, spec);
            int distToRight = obj.getType() == 2 ? TLAtoPCalMapping.Dist(new PCalLocation(tokAtOrRightOfBeginning.getLine(), ((MappingObject.BeginTLAToken)obj).getColumn()), regEnd) : TLAtoPCalMapping.Dist(new PCalLocation(tokAtOrRightOfBeginning.getLine(), ((MappingObject.SourceToken)obj).getBeginColumn()), regEnd);
            PCalLocation leftBegin = null;
            PCalLocation rightEnd = null;
            if (distToLeft >= distToRight) {
                rightEnd = tokAtOrRightOfBeginning;
                notDone = true;
                while (rightEnd != null && notDone) {
                    type = TLAtoPCalMapping.ObjectAt(rightEnd, spec).getType();
                    if (type == 3 || type == 4) {
                        notDone = false;
                    }
                    if (!notDone) continue;
                    rightEnd = TLAtoPCalMapping.NextLocOf(rightEnd, spec);
                }
            }
            if (distToLeft <= distToRight) {
                leftBegin = tokAtOrLeftOfEnd;
                notDone = true;
                while (notDone) {
                    type = TLAtoPCalMapping.ObjectAt(leftBegin, spec).getType();
                    if (type == 2 || type == 4) {
                        notDone = false;
                    }
                    if (!notDone) continue;
                    leftBegin = TLAtoPCalMapping.PrevLocOf(leftBegin, spec);
                }
            }
            if (distToLeft > distToRight) {
                return new Region(tokAtOrRightOfBeginning, rightEnd);
            }
            if (distToLeft < distToRight) {
                return new Region(leftBegin, tokAtOrLeftOfEnd);
            }
            return new Region(leftBegin, rightEnd);
        }
        if (tokAtOrLeftOfEnd != null) {
            return new Region(tokAtOrLeftOfEnd, tokAtOrLeftOfEnd);
        }
        return null;
    }

    private static MappingObject ObjectAt(PCalLocation loc, MappingObject[][] map) {
        return map[loc.getLine()][loc.getColumn()];
    }

    private static PCalLocation PrevLocOf(PCalLocation loc, MappingObject[][] map) {
        if (loc.getColumn() > 0) {
            return new PCalLocation(loc.getLine(), loc.getColumn() - 1);
        }
        int i = loc.getLine() - 1;
        while (i >= 0) {
            if (map[i].length > 0) {
                return new PCalLocation(i, map[i].length - 1);
            }
            --i;
        }
        return null;
    }

    private static PCalLocation NextLocOf(PCalLocation loc, MappingObject[][] map) {
        if (loc.getColumn() + 1 < map[loc.getLine()].length) {
            return new PCalLocation(loc.getLine(), loc.getColumn() + 1);
        }
        int i = loc.getLine() + 1;
        while (i < map.length) {
            if (map[i].length > 0) {
                return new PCalLocation(i, 0);
            }
            ++i;
        }
        return null;
    }

    private static boolean LTEq(PCalLocation locA, PCalLocation locB) {
        if (locA.getLine() == locB.getLine()) {
            return locA.getColumn() <= locB.getColumn();
        }
        return locA.getLine() < locB.getLine();
    }

    private static boolean LT(PCalLocation locA, PCalLocation locB) {
        if (locA.getLine() == locB.getLine()) {
            return locA.getColumn() < locB.getColumn();
        }
        return locA.getLine() < locB.getLine();
    }

    private static int Dist(PCalLocation locA, PCalLocation locB) {
        return 9999 * Math.abs(locA.getLine() - locB.getLine()) + Math.abs(locA.getColumn() - locB.getColumn());
    }

    public static Vector<Vector<MappingObject>> RemoveRedundantParens(Vector<Vector<MappingObject>> mappingVec) {
        Vector<Vector<MappingObject>> out = new Vector<Vector<MappingObject>>();
        Vector<PCalLocation> unmatchedLeft = new Vector<PCalLocation>();
        PCalLocation lastMatchedLeft = null;
        PCalLocation lastAddedRight = null;
        int i = 0;
        while (i < mappingVec.size()) {
            Vector<MappingObject> inLine = mappingVec.elementAt(i);
            Vector<MappingObject> outLine = new Vector<MappingObject>();
            out.addElement(outLine);
            int j = 0;
            while (j < inLine.size()) {
                MappingObject inObj = inLine.elementAt(j);
                if (inObj.getType() == 0) {
                    unmatchedLeft.addElement(new PCalLocation(i, outLine.size()));
                } else if (inObj.getType() == 1) {
                    PCalLocation lastUnmatchedLeft = null;
                    if (unmatchedLeft.size() != 0) {
                        lastUnmatchedLeft = (PCalLocation)unmatchedLeft.elementAt(unmatchedLeft.size() - 1);
                    }
                    if (TLAtoPCalMapping.IsNextIn(lastAddedRight, new PCalLocation(i, j), mappingVec) && TLAtoPCalMapping.IsNextIn(lastUnmatchedLeft, lastMatchedLeft, out)) {
                        out.elementAt(lastMatchedLeft.getLine()).remove(lastMatchedLeft.getColumn());
                        Vector<MappingObject> lastLine = outLine;
                        int lastLineNum = out.size() - 1;
                        while (lastLine.size() == 0) {
                            lastLine = out.elementAt(--lastLineNum);
                        }
                        lastLine.remove(lastLine.size() - 1);
                    }
                    lastMatchedLeft = (PCalLocation)unmatchedLeft.remove(unmatchedLeft.size() - 1);
                    lastAddedRight = new PCalLocation(i, j);
                }
                outLine.addElement(inObj);
                ++j;
            }
            ++i;
        }
        return out;
    }

    private static boolean IsNextIn(PCalLocation locA, PCalLocation locB, Vector<Vector<MappingObject>> vec) {
        return locA != null && locB != null && (locA.getLine() == locB.getLine() && locA.getColumn() + 1 == locB.getColumn() || locA.getLine() == locB.getLine() - 1 && locA.getColumn() == vec.elementAt(locA.getLine()).size() && locB.getColumn() == 0);
    }
}

