/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.ui.navigator.ToolboxExplorer;
import org.lamport.tla.toolbox.ui.wizard.NewSpecWizard;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class NewSpecHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "toolbox.command.spec.new";
    public static final String PARAM_PATH = "toolbox.command.spec.new.param";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        NewSpecWizard wizard = new NewSpecWizard(event.getParameter(PARAM_PATH));
        wizard.init(window.getWorkbench(), null);
        Shell parentShell = window.getShell();
        WizardDialog dialog = new WizardDialog(parentShell, (IWizard)wizard);
        dialog.setHelpAvailable(true);
        if (dialog.open() == 0 && wizard.getRootFilename() != null) {
            boolean importExisting = wizard.isImportExisting();
            String specName = wizard.getSpecName();
            String rootFilename = wizard.getRootFilename();
            this.createModuleAndSpecInNonUIThread(rootFilename, importExisting, specName);
        }
        return null;
    }

    private void createModuleAndSpecInNonUIThread(String rootFilename, boolean importExisting, String specName) {
        Assert.isNotNull((Object)rootFilename);
        Assert.isNotNull((Object)specName);
        NewSpecHandlerJob job = new NewSpecHandlerJob(specName, rootFilename, importExisting);
        job.schedule();
    }

    public static class NewSpecHandlerJob
    extends ToolboxJob {
        private final String specName;
        private final String rootFilename;
        private final boolean importExisting;

        public NewSpecHandlerJob(String specName, String rootFilename, boolean importExisting) {
            super("NewSpecWizard job");
            this.specName = specName;
            this.rootFilename = rootFilename;
            this.importExisting = importExisting;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProject project = ResourceHelper.getProject(this.specName);
            if (project.exists() && Activator.getSpecManager().getSpecByName(this.specName) == null) {
                Activator.getSpecManager().addSpec(new Spec(project, project.getFile("Delete me")));
                UIHelper.runUIAsync(new Runnable(){

                    @Override
                    public void run() {
                        ToolboxExplorer.refresh();
                    }
                });
                return new Status(4, "org.lamport.tla.toolbox", String.format("The workspace already contains a spec by the name '%1$s' located at '%2$s'. Please delete the spec '%1$s [ %3$s ]' from the Spec Explorer. Afterwards, try to create your new spec again.\nIf there is no spec '%1$s [ %3$s ]' in the Spec Explorer, then this is a bug. Please file a bug report and choose a different specification name when you create a new spec in the meantime.", this.specName, project.getLocation().toOSString(), "Delete me"));
            }
            Path rootNamePath = new Path(this.rootFilename);
            try {
                if (!rootNamePath.toFile().exists()) {
                    IWorkspaceRunnable createTLAModuleCreationOperation = ResourceHelper.createTLAModuleCreationOperation((IPath)rootNamePath);
                    ResourcesPlugin.getWorkspace().run(createTLAModuleCreationOperation, monitor);
                }
                Spec spec = Spec.createNewSpec(this.specName, this.rootFilename, this.importExisting, monitor);
                Activator.getSpecManager().addSpec(spec);
                this.openEditorInUIThread(spec);
            }
            catch (CoreException e) {
                String message = "Error creating module " + String.valueOf(rootNamePath);
                Activator.getDefault().logError(message, e);
                return new Status(4, "org.lamport.tla.toolbox", message, (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private void openEditorInUIThread(final Spec spec) {
            UIJob uiJob = new UIJob("NewSpecWizardEditorOpener"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("toolbox.command.spec.open.param", spec.getName());
                    UIHelper.runCommand("toolbox.command.spec.open", parameters);
                    return Status.OK_STATUS;
                }
            };
            uiJob.schedule();
        }
    }
}

