/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.part;

import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.dialog.FilteredDefinitionSelectionDialog;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.BasicFormPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.part.ValidateableConstantSectionPart;
import org.lamport.tla.toolbox.tool.tlc.ui.wizard.AssignmentWizard;
import org.lamport.tla.toolbox.tool.tlc.util.ModelHelper;
import tla2sany.semantic.OpDefNode;
import tlc2.model.Assignment;

public class ValidateableOverridesSectionPart
extends ValidateableConstantSectionPart {
    private final IPropertyChangeListener m_preferenceChangeListener = event -> {
        if ("definitionOverrideStyle".equals(event.getProperty())) {
            this.tableViewer.refresh(true);
        }
    };

    public ValidateableOverridesSectionPart(Composite composite, String title, String description, FormToolkit toolkit, int flags, BasicFormPage page) {
        super(composite, title, description, toolkit, flags, page, "__definition_override");
        IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
        ips.addPropertyChangeListener(this.m_preferenceChangeListener);
    }

    public void dispose() {
        IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
        ips.removePropertyChangeListener(this.m_preferenceChangeListener);
        super.dispose();
    }

    @Override
    protected Assignment doEditFormula(Assignment formula) {
        OpDefNode opDefNode;
        if (formula == null) {
            String[] names = null;
            Object input = this.getTableViewer().getInput();
            if (input != null && input instanceof Vector) {
                Vector inputVec = (Vector)input;
                names = new String[inputVec.size()];
                int i = 0;
                while (i < names.length) {
                    Object next = inputVec.elementAt(i);
                    if (next != null && next instanceof Assignment) {
                        Assignment nextAss = (Assignment)next;
                        names[i] = nextAss.getLabel();
                    } else {
                        names[i] = "";
                    }
                    ++i;
                }
            } else {
                names = new String[]{};
            }
            FilteredDefinitionSelectionDialog definitionSelection = new FilteredDefinitionSelectionDialog(this.getSection().getShell(), false, ToolboxHandle.getCurrentSpec().getValidRootModule(), names);
            definitionSelection.setTitle("Select Definition to Override");
            definitionSelection.setMessage("Type definition to override or select from the list below\n(?= any character, *= any string)");
            definitionSelection.setInitialPattern("?");
            if (definitionSelection.open() == 0) {
                OpDefNode result = (OpDefNode)definitionSelection.getResult()[0];
                formula = new Assignment(result.getName().toString(), Assignment.getArrayOfEmptyStrings((int)result.getSource().getNumberOfArgs()), "");
            } else {
                return null;
            }
        }
        if ((opDefNode = ModelHelper.getOpDefNode((String)formula.getLabel())) != null && opDefNode.getSource().getNumberOfArgs() != formula.getParams().length) {
            String[] newParams = new String[opDefNode.getSource().getNumberOfArgs()];
            int i = 0;
            while (i < newParams.length) {
                newParams[i] = "";
                ++i;
            }
            formula.setParams(newParams);
        }
        AssignmentWizard wizard = new AssignmentWizard(this.getSection().getText(), this.getSection().getDescription(), formula, 2, "definition_override_wizard");
        WizardDialog dialog = new WizardDialog(this.getTableViewer().getTable().getShell(), (IWizard)wizard);
        wizard.setWizardDialog(dialog);
        dialog.setHelpAvailable(true);
        if (dialog.open() == 0) {
            return wizard.getFormula();
        }
        return null;
    }

    @Override
    protected void createButtons(Composite sectionArea, FormToolkit toolkit, boolean add, boolean edit, boolean remove) {
        this.doCreateButtons(sectionArea, toolkit, true, true, true);
    }

    @Override
    protected TableViewer createTableViewer(Table table) {
        TableViewer tableViewer = super.createTableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Assignment) {
                    boolean appendOverriddenModelValue;
                    IPreferenceStore ips = TLCUIActivator.getDefault().getPreferenceStore();
                    String style = ips.getString("definitionOverrideStyle");
                    boolean moduleNameStyle = "byModuleName".equals(style);
                    Assignment assign = (Assignment)element;
                    String label = assign.getLabel();
                    Object noBangLabel = label.substring(label.lastIndexOf("!") + 1);
                    OpDefNode node = ModelHelper.getOpDefNode((String)label);
                    if (moduleNameStyle && node != null && node.getSource() != node) {
                        noBangLabel = (String)noBangLabel + " [" + node.getSource().getOriginallyDefinedInModuleNode().getName().toString() + "]";
                    }
                    boolean bl = appendOverriddenModelValue = assign.isModelValue() && node != null && node.getSource() != node;
                    if (appendOverriddenModelValue && !moduleNameStyle) {
                        return assign.toString() + " " + (String)noBangLabel;
                    }
                    Object rightSide = assign.isModelValue() ? noBangLabel : assign.getRight();
                    Assignment assignNoBang = new Assignment((String)noBangLabel, assign.getParams(), (String)rightSide);
                    return assignNoBang.toString() + (String)(appendOverriddenModelValue ? " " + (String)noBangLabel : "");
                }
                return super.getText(element);
            }
        });
        return tableViewer;
    }
}

