/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer;
import org.lamport.tla.toolbox.editor.basic.util.DocumentHelper;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import pcal.Region;
import pcal.TLAtoPCalMapping;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.parser.Operators;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AssumeProveNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NewSymbNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.Location;
import util.UniqueString;

public class EditorUtil {
    public static final String READ_ONLY_MODULE_MARKER = "org.lamport.tla.toolbox.editor.basic.readOnly";
    public static final String IS_READ_ONLY_ATR = "org.lamport.tla.toolbox.editor.basic.isReadOnly";

    public static TLAEditor getTLAEditorWithFocus() {
        TLAEditor editor;
        IEditorPart activeEditor = UIHelper.getActiveEditor();
        if (activeEditor instanceof TLAEditorAndPDFViewer) {
            TLAEditor editor2 = ((TLAEditorAndPDFViewer)activeEditor).getTLAEditor();
            if (editor2 != null && editor2.getViewer().getTextWidget().isFocusControl()) {
                return editor2;
            }
        } else if (activeEditor != null && activeEditor.getAdapter(TLAEditor.class) != null && (editor = (TLAEditor)((Object)activeEditor.getAdapter(TLAEditor.class))) != null && editor.getViewer().getTextWidget().isFocusControl()) {
            return editor;
        }
        return null;
    }

    public static TLAEditor getActiveTLAEditor() {
        IEditorPart activeEditor = UIHelper.getActiveEditor();
        if (activeEditor instanceof TLAEditorAndPDFViewer) {
            return ((TLAEditorAndPDFViewer)activeEditor).getTLAEditor();
        }
        return (TLAEditor)((Object)activeEditor.getAdapter(TLAEditor.class));
    }

    public static boolean locationContainment(Location loc1, Location loc2) {
        if (loc1.beginLine() < loc2.beginLine() || loc1.beginLine() == loc2.beginLine() && loc1.beginColumn() < loc2.beginColumn()) {
            return false;
        }
        return loc1.endLine() < loc2.endLine() || loc1.endLine() == loc2.endLine() && loc1.endColumn() <= loc2.endColumn();
    }

    public static boolean lineLocationContainment(Location loc1, Location loc2) {
        return loc1.beginLine() >= loc2.beginLine() && loc2.endLine() >= loc1.endLine();
    }

    public static StringAndLocation getTokenAt(IDocument document, int offset, int length) {
        Location location = EditorUtil.getLocationAt(document, offset, length);
        return EditorUtil.getTokenAtLocation(location);
    }

    public static StringAndLocation getCurrentToken() {
        Location location = EditorUtil.getCurrentLocation();
        if (location == null) {
            return null;
        }
        return EditorUtil.getTokenAtLocation(location);
    }

    public static StringAndLocation getTokenAtLocation(Location location) {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null) {
            return null;
        }
        IFile moduleFile = ((FileEditorInput)editor.getEditorInput()).getFile();
        if (editor.isDirty()) {
            TLAEditorActivator.getDefault().logDebug("Editor is dirty");
            return null;
        }
        ParseResult parseResult = ResourceHelper.getValidParseResult((IFile)moduleFile);
        if (parseResult == null || parseResult.getStatus() != 0) {
            return null;
        }
        String moduleName = ResourceHelper.getModuleName((IResource)moduleFile);
        ModuleNode module = parseResult.getSpecObj().getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
        if (module == null) {
            return null;
        }
        SyntaxTreeNode stn = (SyntaxTreeNode)module.stn;
        if (!EditorUtil.locationContainment(location, stn.getLocation())) {
            return null;
        }
        StringAndLocation stl = EditorUtil.innerGetCurrentToken(stn, location);
        if (stl == null) {
            return null;
        }
        if (stl.string.charAt(0) == '<' && stl.string.indexOf(46) != -1) {
            Location loc = stl.location;
            stl = new StringAndLocation(stl.string.substring(0, stl.string.indexOf(46)), new Location(UniqueString.uniqueStringOf((String)loc.source()), loc.beginLine(), loc.beginColumn(), loc.endLine(), loc.beginColumn() + stl.string.indexOf(46)));
        }
        return stl;
    }

    private static StringAndLocation innerGetCurrentToken(SyntaxTreeNode stn, Location location) {
        int kind = stn.getKind();
        if (kind == 358) {
            return new StringAndLocation(EditorUtil.concatHeirTokens(stn), stn.getLocation());
        }
        SyntaxTreeNode[] heirs = stn.getHeirs();
        if (heirs.length == 0) {
            return new StringAndLocation(stn.getImage(), stn.getLocation());
        }
        int i = 0;
        while (i < heirs.length) {
            if (EditorUtil.locationContainment(location, heirs[i].getLocation())) {
                return EditorUtil.innerGetCurrentToken(heirs[i], location);
            }
            ++i;
        }
        return null;
    }

    private static String concatHeirTokens(SyntaxTreeNode stn) {
        SyntaxTreeNode[] heirs = stn.getHeirs();
        if (heirs.length == 0) {
            if (stn.getKind() < 327) {
                return stn.getImage();
            }
            return "";
        }
        Object val = "";
        int i = 0;
        while (i < heirs.length) {
            val = (String)val + EditorUtil.concatHeirTokens(heirs[i]);
            ++i;
        }
        return val;
    }

    public static Location getCurrentLocation() {
        return EditorUtil.getCurrentLocation(0);
    }

    public static Location getCurrentLocation(int x) {
        ITextSelection selection = EditorUtil.getCurrentSelection();
        return EditorUtil.getLocationAt(EditorUtil.getCurrentDocument(), selection.getOffset(), selection.getLength(), x);
    }

    private static IDocument getCurrentDocument() {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null) {
            return null;
        }
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    private static ITextSelection getCurrentSelection() {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        return (ITextSelection)editor.getSelectionProvider().getSelection();
    }

    public static IRegion getRegionOf(IDocument document, Location location) throws BadLocationException {
        int offset = document.getLineInformation(location.beginLine() - 1).getOffset() + location.beginColumn() - 1;
        int length = document.getLineInformation(location.endLine() - 1).getOffset() + location.endColumn() - offset;
        return new org.eclipse.jface.text.Region(offset, length);
    }

    public static Location getLocationAt(IDocument document, int offset, int length) {
        return EditorUtil.getLocationAt(document, offset, length, 0);
    }

    public static Location getLocationAt(IDocument document, int offset, int length, int x) {
        if (document == null) {
            return null;
        }
        Location loc = null;
        try {
            int startOffset = offset;
            int startLine = document.getLineOfOffset(startOffset);
            int startCol = startOffset - document.getLineOffset(startLine) + 1;
            int endOffset = startOffset + length;
            int endLine = document.getLineOfOffset(endOffset);
            int endCol = endOffset - document.getLineOffset(endLine);
            if (length == 0) {
                ++endCol;
            }
            loc = new Location(startLine + 1, startCol, endLine + 1, endCol + x);
        }
        catch (BadLocationException e) {
            return null;
        }
        return loc;
    }

    public static SymbolNode lookupSymbol(SpecObj specObj, IDocument document, DocumentHelper.WordRegion region) {
        Location location = EditorUtil.getLocationAt(document, region.getOffset(), region.getLength());
        ModuleNode rootModule = specObj.getExternalModuleTable().getRootModule();
        return EditorUtil.lookupSymbol(UniqueString.uniqueStringOf((String)region.getWord()), (SemanticNode)rootModule, location, null);
    }

    public static SymbolNode lookupSymbol(String name, SymbolNode curNode, IDocument document, IRegion region, SymbolNode defaultResult) {
        Location location = EditorUtil.getLocationAt(document, region.getOffset(), region.getLength());
        return EditorUtil.lookupSymbol(UniqueString.uniqueStringOf((String)name), (SemanticNode)curNode, location, defaultResult);
    }

    public static SymbolNode lookupSymbol(UniqueString name, SemanticNode curNode, Location location, SymbolNode defaultResult) {
        SemanticNode[] children;
        TheoremNode thm;
        LevelNode assertion;
        SymbolNode foundSymbol = null;
        if (curNode instanceof ModuleNode) {
            foundSymbol = ((ModuleNode)curNode).getContext().getSymbol((Object)name);
        } else if (curNode instanceof LetInNode) {
            foundSymbol = ((LetInNode)curNode).context.getSymbol((Object)name);
        } else if (curNode instanceof NonLeafProofNode) {
            foundSymbol = ((NonLeafProofNode)curNode).getContext().getSymbol((Object)name);
        } else if (curNode instanceof OpApplNode) {
            FormalParamNode[][] fpnA;
            OpApplNode oan = (OpApplNode)curNode;
            FormalParamNode[] fpn = oan.getUnbdedQuantSymbols();
            if (fpn != null) {
                int i = 0;
                while (i < fpn.length) {
                    if (fpn[i].getName() == name) {
                        foundSymbol = fpn[i];
                        break;
                    }
                    ++i;
                }
            }
            if ((fpnA = oan.getBdedQuantSymbolLists()) != null) {
                int i = 0;
                while (i < fpnA.length) {
                    int j = 0;
                    while (j < fpnA[i].length) {
                        if (fpnA[i][j].getName() == name) {
                            foundSymbol = fpnA[i][j];
                            i = fpnA.length;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        } else if (curNode instanceof OpDefNode) {
            FormalParamNode[] params = ((OpDefNode)curNode).getParams();
            int i = 0;
            while (i < params.length) {
                if (name == params[i].getName()) {
                    foundSymbol = params[i];
                    break;
                }
                ++i;
            }
        } else if (curNode instanceof TheoremNode && (assertion = (thm = (TheoremNode)curNode).getTheorem()) instanceof AssumeProveNode) {
            AssumeProveNode apn = (AssumeProveNode)assertion;
            SemanticNode[] assumes = apn.getAssumes();
            if (!apn.getSuffices()) {
                int i = 0;
                while (i < assumes.length) {
                    NewSymbNode newSymb;
                    OpDeclNode opDecl;
                    if (assumes[i] instanceof NewSymbNode && name == (opDecl = (newSymb = (NewSymbNode)assumes[i]).getOpDeclNode()).getName()) {
                        foundSymbol = opDecl;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (foundSymbol == null) {
            foundSymbol = defaultResult;
        }
        if ((children = curNode.getChildren()) == null) {
            return foundSymbol;
        }
        int i = 0;
        while (i < children.length) {
            if (EditorUtil.locationContainment(location, children[i].getLocation())) {
                foundSymbol = EditorUtil.lookupSymbol(name, children[i], location, foundSymbol);
            }
            ++i;
        }
        return foundSymbol;
    }

    public static SymbolNode lookupOriginalSymbol(UniqueString name, SemanticNode curNode, Location location, SymbolNode defaultResult) {
        ThmOrAssumpDefNode opdef;
        SymbolNode resolvedSymbol = EditorUtil.lookupSymbol(name = Operators.resolveSynonym((UniqueString)name), curNode, location, defaultResult);
        if (resolvedSymbol == null) {
            return null;
        }
        if (resolvedSymbol instanceof OpDefNode) {
            OpDefNode opdef2 = (OpDefNode)resolvedSymbol;
            if (opdef2.getSource() != null) {
                resolvedSymbol = opdef2.getSource();
            }
        } else if (resolvedSymbol instanceof ThmOrAssumpDefNode && (opdef = (ThmOrAssumpDefNode)resolvedSymbol).getSource() != null) {
            resolvedSymbol = opdef.getSource();
        }
        return resolvedSymbol;
    }

    public static TLAEditor openTLAEditor(String moduleFileName) {
        IResource module = ResourceHelper.getResourceByName((String)moduleFileName);
        if (module != null && module instanceof IFile) {
            IEditorPart editor = UIHelper.openEditor((String)"org.lamport.tla.toolbox.editor.basic.TLAEditor", (IFile)((IFile)module));
            if (editor instanceof TLAEditor) {
                return (TLAEditor)editor;
            }
            if (editor instanceof TLAEditorAndPDFViewer) {
                return ((TLAEditorAndPDFViewer)editor).getTLAEditor();
            }
        }
        return null;
    }

    public static TLAEditor findTLAEditor(IResource module) {
        IEditorPart editor;
        if (module != null && module instanceof IFile && (editor = UIHelper.getActivePage().findEditor((IEditorInput)new FileEditorInput((IFile)module))) instanceof TLAEditorAndPDFViewer) {
            return ((TLAEditorAndPDFViewer)editor).getTLAEditor();
        }
        return null;
    }

    public static TheoremNode getCurrentTheoremNode() {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null || editor.isDirty()) {
            return null;
        }
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        Assert.isNotNull((Object)selectionProvider, (String)"Active editor does not have a selection provider. This is a bug.");
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (editor.getEditorInput() instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
            String moduleName = ResourceHelper.getModuleName((IResource)file);
            ParseResult parseResult = ResourceHelper.getValidParseResult((IFile)file);
            return ResourceHelper.getTheoremNodeWithCaret((ParseResult)parseResult, (String)moduleName, (ITextSelection)textSelection, (IDocument)document);
        }
        return null;
    }

    public static boolean editorWithFocusDirty() {
        return EditorUtil.getTLAEditorWithFocus().isDirty();
    }

    public static String moduleWithFocus() {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
        String name = ResourceHelper.getModuleName((IResource)file);
        return name;
    }

    public static void setReadOnly(IResource module, boolean isReadOnly) {
        try {
            if (module.exists()) {
                IMarker marker;
                IMarker[] foundMarkers = module.findMarkers(READ_ONLY_MODULE_MARKER, false, 0);
                if (foundMarkers.length > 0) {
                    marker = foundMarkers[0];
                    int i = 1;
                    while (i < foundMarkers.length) {
                        foundMarkers[i].delete();
                        ++i;
                    }
                } else {
                    marker = module.createMarker(READ_ONLY_MODULE_MARKER);
                }
                marker.setAttribute(IS_READ_ONLY_ATR, isReadOnly);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error setting module " + String.valueOf(module) + " to read only.", (Throwable)e);
        }
    }

    public static void setReturnFromOpenDecl() {
        TLAEditor srcEditor = EditorUtil.getTLAEditorWithFocus();
        EditorUtil.setReturnFromOpenDecl(srcEditor);
    }

    public static void setReturnFromOpenDecl(TLAEditor srcEditor) {
        if (srcEditor != null) {
            Spec spec = ToolboxHandle.getCurrentSpec();
            spec.setOpenDeclModuleName((ITextEditor)srcEditor);
        }
    }

    public static boolean isReadOnly(IResource module) {
        try {
            if (module.exists()) {
                IMarker[] foundMarkers = module.findMarkers(READ_ONLY_MODULE_MARKER, false, 0);
                if (foundMarkers.length > 0) {
                    IMarker marker = foundMarkers[0];
                    int i = 1;
                    while (i < foundMarkers.length) {
                        foundMarkers[i].delete();
                        ++i;
                    }
                    return marker.getAttribute(IS_READ_ONLY_ATR, false);
                }
                return false;
            }
            return false;
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error determining if module " + String.valueOf(module) + " is read only.", (Throwable)e);
            return false;
        }
    }

    public static Position getMarkerPosition(IMarker marker) {
        TLAEditor editor = EditorUtil.findTLAEditor(marker.getResource());
        if (editor != null) {
            IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
            if (annotationModel instanceof ResourceMarkerAnnotationModel) {
                return ((ResourceMarkerAnnotationModel)annotationModel).getMarkerPosition(marker);
            }
            Activator.getDefault().logDebug("Cannot get the annotation model that manages marker positions for the marker on " + String.valueOf(marker.getResource()));
        }
        return null;
    }

    public static boolean selectAndRevealPCalRegionFromCurrentTLARegion() throws BadLocationException {
        TLAtoPCalMapping mapping = EditorUtil.getTLAEditorWithFocus().getTpMapping();
        if (mapping == null) {
            UIHelper.setStatusLineMessage((String)"No valid TLA to PCal mapping found for current selection");
            return false;
        }
        IDocument document = EditorUtil.getCurrentDocument();
        Region sourceRegion = AdapterFactory.jumptToPCal((TLAtoPCalMapping)mapping, (Location)EditorUtil.getCurrentLocation(1), (IDocument)document);
        if (sourceRegion == null) {
            return false;
        }
        EditorUtil.setReturnFromOpenDecl();
        EditorUtil.getTLAEditorWithFocus().selectAndReveal(sourceRegion);
        return true;
    }

    public static final class StringAndLocation {
        public String string;
        public Location location;

        public StringAndLocation(String string, Location location) {
            this.string = string;
            this.location = location;
        }

        public String toString() {
            return "[string |-> " + this.string + ", location |-> " + this.location.toString() + "]";
        }
    }
}

