/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.handlers.CommandPrefixDigitHandler;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;

public class CursorMovementHandler
extends AbstractHandler
implements IHandler {
    private ISelectionProvider selectionProvider;
    private int offset;
    private IRegion lineInfo;
    public final String charRightId = "org.lamport.tla.toolbox.editor.basic.charRight";
    public final String charLeftId = "org.lamport.tla.toolbox.editor.basic.charLeft";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null) {
            return null;
        }
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.selectionProvider = editor.getSelectionProvider();
        TextSelection selection = (TextSelection)this.selectionProvider.getSelection();
        this.offset = selection.getOffset();
        if (this.offset < 0) {
            return null;
        }
        try {
            this.lineInfo = doc.getLineInformationOfOffset(this.offset);
            String cmd = event.getCommand().getId();
            int repeatVal = CommandPrefixDigitHandler.getAndResetRepeatValue(editor);
            while (repeatVal > 0) {
                --repeatVal;
                if (cmd.equals("org.lamport.tla.toolbox.editor.basic.charRight")) {
                    this.charRight();
                    continue;
                }
                if (cmd.equals("org.lamport.tla.toolbox.editor.basic.charLeft")) {
                    this.charLeft();
                    continue;
                }
                System.out.println("Unrecognized command.");
                System.out.println(cmd);
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        return null;
    }

    public boolean isEnabled() {
        if (EditorUtil.getTLAEditorWithFocus() == null) {
            return false;
        }
        return super.isEnabled();
    }

    private void charRight() {
        if (this.offset < this.lineInfo.getOffset() + this.lineInfo.getLength()) {
            this.selectionProvider.setSelection((ISelection)new TextSelection(this.offset + 1, 0));
            ++this.offset;
        }
    }

    private void charLeft() {
        if (this.offset > this.lineInfo.getOffset()) {
            this.selectionProvider.setSelection((ISelection)new TextSelection(this.offset - 1, 0));
            --this.offset;
        }
    }
}

