/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.lamport.tla.toolbox.editor.basic.pcal.PCalWordDetector;
import org.lamport.tla.toolbox.editor.basic.util.DocumentHelper;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.SymbolNode;

public class ToolboxHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        DocumentHelper.WordRegion wordRegion;
        try {
            wordRegion = DocumentHelper.getRegionExpandedBoth(textViewer.getDocument(), hoverRegion.getOffset(), new PCalWordDetector());
        }
        catch (BadLocationException ignore) {
            return null;
        }
        String hoverInfo = this.getHoverInfo(textViewer.getDocument(), wordRegion);
        if (hoverInfo != null) {
            return hoverInfo;
        }
        SpecObj spec = ToolboxHandle.getSpecObj();
        if (spec != null) {
            SymbolNode symbol = EditorUtil.lookupSymbol(spec, textViewer.getDocument(), wordRegion);
            if (symbol == null) {
                return null;
            }
            return symbol.getHumanReadableImage();
        }
        return null;
    }

    protected String getHoverInfo(IDocument document, DocumentHelper.WordRegion wordRegion) {
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }
}

