/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.intro.universal.BaseData;
import org.eclipse.ui.internal.intro.universal.ExtensionData;
import org.eclipse.ui.internal.intro.universal.GroupData;
import org.eclipse.ui.intro.config.IntroElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageData {
    public static final String P_TOP_LEFT = "page-content/top-left";
    public static final String P_TOP_RIGHT = "page-content/top-right";
    public static final String P_BOTTOM_LEFT = "page-content/bottom-left";
    public static final String P_BOTTOM_RIGHT = "page-content/bottom-right";
    private String id;
    private ArrayList<GroupData> groups = new ArrayList();
    private GroupData hidden = null;

    public PageData(String id) {
        this.id = id;
    }

    public PageData(Element page) {
        this.id = page.getAttribute("id");
        NodeList children = page.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element element = (Element)child;
                if (element.getNodeName().equals("group")) {
                    this.addGroup(element, false);
                } else if (element.getNodeName().equals("hidden")) {
                    this.addGroup(element, true);
                }
            }
            ++i;
        }
    }

    public void add(GroupData gd) {
        if (gd.isHidden()) {
            this.hidden = gd;
        } else {
            this.groups.add(gd);
        }
    }

    public void addAnchors(List<IntroElement> result, String groupId) {
        GroupData group = this.findGroup(groupId);
        if (group == null) {
            return;
        }
        group.addAnchors(result);
    }

    public String resolvePath(String extensionId) {
        if (this.isHidden(extensionId)) {
            return null;
        }
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gdata = this.groups.get(i);
            if (gdata.contains(extensionId)) {
                IPath resolvedPath = IPath.fromOSString((String)this.id);
                resolvedPath = resolvedPath.append(gdata.getPath());
                resolvedPath = resolvedPath.append(extensionId);
                return resolvedPath.toString();
            }
            ++i;
        }
        return null;
    }

    public String resolveDefaultPath() {
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gdata = this.groups.get(i);
            if (gdata.isDefault()) {
                IPath resolvedPath = IPath.fromOSString((String)this.id).append(gdata.getPath());
                resolvedPath = resolvedPath.append("defaultAnchor");
                return resolvedPath.toString();
            }
            ++i;
        }
        return null;
    }

    public boolean isHidden(String extensionId) {
        return this.hidden != null && this.hidden.contains(extensionId);
    }

    public GroupData findGroup(String groupId) {
        if (groupId.equals("hidden")) {
            return this.hidden;
        }
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gdata = this.groups.get(i);
            IPath path = IPath.fromOSString((String)gdata.getPath());
            if (path.lastSegment().equals(groupId)) {
                return gdata;
            }
            ++i;
        }
        return null;
    }

    private void addGroup(Element element, boolean hide) {
        GroupData gd = new GroupData(element);
        if (hide) {
            this.hidden = gd;
        } else {
            this.groups.add(gd);
        }
    }

    public void addImplicitExtension(String extensionId, String name) {
        ExtensionData ed = this.findExtension(extensionId, true);
        if (ed != null) {
            if (ed.getName() == null || ed.getName().length() == 0) {
                ed.setName(name);
            }
            return;
        }
        GroupData gd = this.findDefaultGroup();
        if (gd == null && this.groups.isEmpty()) {
            gd = new GroupData(P_BOTTOM_LEFT, true);
            this.groups.add(gd);
            this.groups.add(new GroupData(P_BOTTOM_RIGHT, true));
        }
        if (gd != null) {
            gd.addImplicitExtension(extensionId, name);
        }
    }

    private GroupData findDefaultGroup() {
        GroupData defaultGroup = null;
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gd = this.groups.get(i);
            if (gd.isDefault()) {
                if (defaultGroup == null) {
                    defaultGroup = gd;
                } else if (defaultGroup.getExtensionCount() > gd.getExtensionCount()) {
                    defaultGroup = gd;
                }
            }
            ++i;
        }
        return defaultGroup;
    }

    public String getId() {
        return this.id;
    }

    public ExtensionData findExtension(String extensionId, boolean checkHidden) {
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gdata = this.groups.get(i);
            ExtensionData ed = this.find(gdata, extensionId);
            if (ed != null) {
                return ed;
            }
            ++i;
        }
        if (checkHidden && this.hidden != null) {
            return this.find(this.hidden, extensionId);
        }
        return null;
    }

    private ExtensionData find(GroupData gd, String extensionId) {
        BaseData bd = gd.find(extensionId);
        if (bd != null && bd instanceof ExtensionData) {
            return (ExtensionData)bd;
        }
        return null;
    }

    public String resolveExtension(String extensionId) {
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gdata = this.groups.get(i);
            if (gdata.contains(extensionId)) {
                return this.id + "/" + gdata.getPath() + "/" + extensionId;
            }
            ++i;
        }
        if (this.hidden != null && this.hidden.contains(extensionId)) {
            return null;
        }
        if (this.groups.isEmpty()) {
            return null;
        }
        GroupData last = this.groups.get(this.groups.size() - 1);
        return this.id + "/" + last.getPath() + "/defaultAnchor";
    }

    public void write(PrintWriter writer, String indent) {
        writer.print(indent);
        String indent2 = indent + "   ";
        writer.println("<page id=\"" + this.id + "\">");
        int i = 0;
        while (i < this.groups.size()) {
            GroupData gd = this.groups.get(i);
            gd.write(writer, indent2);
            ++i;
        }
        if (this.hidden != null) {
            this.hidden.write(writer, indent2);
        }
        writer.print(indent);
        writer.println("</page>");
    }
}

